<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$baseDir = 'mp3';
$requestedPath = isset($_GET['path']) ? $_GET['path'] : '';
$fullPath = realpath($baseDir . DIRECTORY_SEPARATOR . $requestedPath);

// Zabezpieczenie przed directory traversal
if (!$fullPath || strpos($fullPath, realpath($baseDir)) !== 0 || !is_dir($fullPath)) {
    echo json_encode(['folders' => [], 'files' => []]);
    exit;
}

$items = scandir($fullPath);
$result = ['folders' => [], 'files' => []];

foreach ($items as $item) {
    if ($item === '.' || $item === '..') continue;
    
    $itemPath = $fullPath . DIRECTORY_SEPARATOR . $item;
    if (is_dir($itemPath)) {
        $result['folders'][] = $item;
    } elseif (strtolower(pathinfo($itemPath, PATHINFO_EXTENSION)) === 'mp3') {
        $result['files'][] = $item;
    }
}

// Sortowanie bez względu na wielkość liter
usort($result['folders'], function($a, $b) {
    return strcasecmp($a, $b);
});
usort($result['files'], function($a, $b) {
    return strcasecmp($a, $b);
});

echo json_encode($result);
?>